dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();

LManager:AddNewTable( 1, 6, 220, 250, "assets/images/table/ballroom_6", "assets/images/food/item_mark3", "R" );
LManager:AddNewTable( 2, 6, 250, 400, "assets/images/table/ballroom_6", "assets/images/food/item_mark2", "B" );

useFloAsServer = 0;
useWineTable = 0;
numMoodBoosts = 2;
numServers = 1;
maxCoupleHappiness = 250;

-- Group 1
guest = LManager.GenGuest(male02);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(uncle);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = table2;
guest.likes = { female04 };
LManager:AddGuest(guest);

LManager:SetSeatingGroup(1, 4, 3000);


-- Group 2

guest = LManager.GenGuest(male02);
guest.matchType = female04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(uncle);
guest.matchType = table2;
guest.percentRequestCoffee = 30;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = table1;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(5, 8, 33000);


-- Group 3

guest = LManager.GenGuest(female01);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = female03;
guest.percentRequestTissue = 40;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = NOT_GUEST + aunt;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male02);
guest.matchType = female03;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(9, 12, 60000);

-- Group 4

guest = LManager.GenGuest(male01);
guest.matchType = aunt;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male02);
guest.matchType = male01;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(13, 14, 80000);


-- Group 5

guest = LManager.GenGuest(male01);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(uncle);
guest.matchType = male01;
guest.percentRequestCoffee = 20;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = male01;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(15, 17, 120000);

-- Group 6

guest = LManager.GenGuest(male04);
guest.matchType = female04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male02);
guest.matchType = female04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = table2;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(18, 20, 140000);

-- Group 7


guest = LManager.GenGuest(male04);
guest.matchType = aunt;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male02);
guest.matchType = male04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = male04;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(21, 23, 170000);


LManager:AdjustGuestTolerance(130);


LManager:SetLevelSetting ("speakerDelay", 80000); 
LManager:SetLevelSetting ("speakerChance", 30);

LManager:SetLevelSetting ("bridesmaidsDelay", 130000); 
LManager:SetLevelSetting ("bridesmaidsChance", 100);

LManager:AddQuinnEvent( "fx/fx_chef_table_fire.lua", 660, 155, 55000 );

-- Set up the Level Settings
LManager:SetLevelNumber(2,10);
LManager:SetLevelScores(10000, 13000);
LManager:SetLevelTime(300000);
LManager:SetLevelSetting ("blaster", 1);

LManager:SetMusic("assets/audio/music/Big Band 2.ogg","assets/audio/music/Dance Dance 1.ogg","assets/audio/music/new_dance_2.ogg");
LManager:SetBackgroundImage("assets/images/bg_ballroom");
LManager:SetChairImage("assets/images/table/chair02");

-- Generate Game Object
gameObject = LManager:GenerateGameObject();

-- Generate Level Settings
levelSetting = LManager:GenerateLevelSettings();

-- Generate Level Dialog
dofile( "scripts/LevelDialogGenerator.lua" );

